mount_vfs_texture_path(current_mod_path.."/Textures/CLP_P8_TEXTURES")

CLP_P8 =  {

-----------------------
-- Name, Shape and Type
-----------------------

    Name 				= 'CLP_P8',
    DisplayName         = _('P-8A Poseidon (CLP)'),
    date_of_introduction= 2012,
    country_of_origin   = "USA",
    Picture             = "CLP_P8.png",
    Rate                = 40, -- RewardPoint in Multiplayer
    Shape               = "CLP_P8",

	WorldID 		= WSTYPE_PLACEHOLDER,

    debrisGeneration    = 1,

    shape_table_data    = {
        {
            file        = "CLP_P8";
            life        = 18; -- life bar -- TODO
            vis         = 3; -- visibility gain -- TODO
            desrt       = "kc-135-oblomok"; -- Name of destroyed object file name
            fire        = {3600, 6}; -- Fire on the ground after destroyed
            username    = "CLP_P8";
            index       = WSTYPE_PLACEHOLDER;
            classname   = "lLandPlane";
            positioning = "BYNORMAL";
            drawonmap = true;
        },
        {
            name = "kc-135-oblomok";
            file = "kc-135-oblomok";
            fire = {3600, 6};
        },
    },

	CanopyGeometry = makeAirplaneCanopyGeometry(LOOK_GOOD, LOOK_AVERAGE, LOOK_AVERAGE),

	--Countries = {"AUSTRALIA", "TURKEY", "SOUTH_KOREA", "RED", "BLUE", "USA"},
	SpecificCallnames = {
		USA = { { "Madfox", "Madfox" }, { "Talon", "Talon" },{ "Trident", "Trident" }, { "Guernsey", "Guernsey" }, { "Stingray", "Stingray" }, {"Mariner", "Mariner"} }
	},

-----------------------
-- SENSORS RADIOS
-----------------------

		passivCounterm = {
			CMDS_Edit = true,
			SingleChargeTotal = 240,
			chaff = {default = 120, increment = 30, chargeSz = 1},
			flare = {default = 60, increment = 15, chargeSz = 2}
        },

        singleInFlight = false,

        attribute = {wsType_Air, wsType_Airplane, wsType_Cruiser, WSTYPE_PLACEHOLDER,
			"Aux",
			"Refuelable", "Datalink", "Link16",
			"Battleplanes",
        },
        Categories = {
 --           pl_cat("{D2BC159C-5B7D-40cf-92CD-44DF3E99FAA9}", ""),
        },
        Sensors = {
		    RADAR = "AN/APS-137", --PLACEHOLDER
			OPTIC = {"RQ-1 Predator CAM", "RQ-1 Predator FLIR"},  --PLACEHOLDER
            RWR = "Abstract RWR"
        },
		laserEquipment = {  --TEST 2022-07-30 FIX for OB 2.7 weapons bug
			laserDesignator = true,
			laserRangefinder = true
		},
		Countermeasures = {
            ECM = "AN/ALQ-172" --PLACEHOLDER
        },

		EPLRS = true,
		radar_can_see_ground	=	true,
		mapclasskey = "P0091000027",

		HumanRadio = {
		frequency = 243.0,
		editable = true,
		minFrequency = 30.000,
		maxFrequency = 399.975,
        rangeFrequency = {
			{min = 30.0,  max = 87.975},
			{min = 108.0, max = 115.975},
			{min = 118.0, max = 173.975},
			{min = 225.0, max = 399.975},
		},
		modulation = MODULATION_AM,
	},
--------


-----------------------
-- DEFINITION
-----------------------

    -----------------------------------------------------------------------------------------------

	M_empty 					= 41145 ,  -- kg
	M_nominal 					= 65317,  -- kg
	M_max 						= 85820,  -- kg
	M_fuel_max 					= 32374,   -- kg  (32374=40530l@1.251kg per l)
	H_max 					 	= 12500,	-- m
	average_fuel_consumption 	= 0.1893,  -- this is highly relative, but good estimates are 36-40l/min = 28-31kg/min = 0.47-0.52kg/s -- 45l/min = 35kg/min = 0.583kg/s
	CAS_min 					= 56,
	V_opt 						= 220,  -- Cruise speed (for AI) 220M/S IS 792KPH
	V_take_off 					= 58,   -- Take off speed in m/s (for AI)
	V_land 						= 61,   -- Land speed in m/s (for AI)
	V_max_sea_level 			= 280.28,  -- Max speed at sea level in m/s (for AI)
	V_max_h 					= 280.28,  -- Max speed at max altitude in m/s (for AI)
	Vy_max 						= 10,   -- Max climb speed in m/s (for AI)
	Mach_max 					= 0.9, -- Max speed in Mach (for AI)
	Ny_min 						= 0.5, -- Min G (for AI) was -4
	Ny_max 						= 2.5,  -- Max G (for AI)
	Ny_max_e 					= 2,  -- Max G (for AI)
	AOA_take_off 				= 0.157, -- AoA in take off (for AI)
	bank_angle_max 				= 45, -- Max bank angle (for AI)

    has_afteburner  = false, -- AFB yes/no
    has_speedbrake  = true, -- Air brake yes/no (spoiler substitute)
    has_differential_stabilizer = false, -- Differential stabilizers yes/no
	has_thrustReverser = true,

    flaps_transmission = "Hydraulic",
--    undercarriage_transmission = "Hydraulic",
--    undercarriage_movement = 2,
    bomb_bay_movement = 2,
    doors_transmission = "Mechanical",
    doors_movement  = 1,

    tand_gear_max   = 3.73, --was 0.577, -- tang(a) <- a = steering angle

    ------------------------------------
	nose_gear_pos = 	{13.961,	-3.222,	0}, -- nosegear coord wheel touch -3.22
	nose_gear_amortizer_direct_stroke   		=  0.0,  -- down from nose_gear_pos !!!
	nose_gear_amortizer_reversal_stroke  		=  -0.4,
	nose_gear_amortizer_normal_weight_stroke 	=  -0.03,
	nose_gear_wheel_diameter 					=  0.628, -- in m

	main_gear_pos = 	{-0.676,	-3.227,	-2.904},  --wheel touch -3.22
	main_gear_amortizer_direct_stroke	 	 	=   0, --  down from main_gear_pos !!!
	main_gear_amortizer_reversal_stroke  	 	=   -0.3, -- 1.9834-1.862
	main_gear_amortizer_normal_weight_stroke 	=  -0.11, -- -0.1,-- down from main_gear_pos
	main_gear_wheel_diameter 				 	=   1.02, -- in m
	------------------------------------

    wing_area       = 125, 	-- Wing area in m2
    wing_span       = 37.64, -- Wing span in metres
    -- change wing type to foldable to use mechanimation to force bomb bay closed if opened by option setting
	wing_type       = 2, -- 0 = Fixed wing
                         -- 1 = Variable geometry
                         -- 2 = Fold-able wing
 --   wing_ad_sections= {0, 0, 0, 1, 1, 2, 2},
    thrust_sum_max  = 24775, -- Thrust in kg (ACTUAL THRUST = 121.4kN*2) was 38100
    thrust_sum_ab   = 24775, -- Thrust in kg
	length 						= 39.5, -- full lenght in m
	height 						= 12.83, -- height in m
	flaps_maneuver 				= 1, -- Max flaps in take-off and maneuver (0.5 = 1st stage; 1.0 = 2nd stage) (for AI) was 0.5
	range 						= 12247, -- Max range in km (for AI)
	RCS 						= 80, -- Radar Cross Section m2
	detection_range_max			= 500,
	IR_emission_coeff 			= 0.1, -- Normal engine -- IR_emission_coeff = 1 is Su-27 without afterburner. It is reference.
	IR_emission_coeff_ab 		= 0, -- With afterburner
	wing_tip_pos = 	{-8.146,	0.787,	19.06}, -- wingtip coords for visual effects
	brakeshute_name 			= 0, -- Landing - brake chute visual shape after separation
	bigParkingRamp								=	true,

		is_tanker	=	false,
		tanker_type	=	1,
		air_refuel_receptacle_pos = 	{13.444,	2.04,	0.0},



    engines_count = 2, -- Engines count
	engines_nozzles = {
		[1] =
		{
 			pos 		=  {-0.038, -1.788, -4.84}, -- nozzle coords
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
			engine_number       = 1,
		}, -- end of [1]
		[2] =
		{
			pos 		=  {-0.038, -1.788, 4.84}, -- nozzle coords
				elevation	=	0,
				diameter	=	1.523,
				exhaust_length_ab	=	11.794,
				exhaust_length_ab_K	=	0.76,
				smokiness_level     = 	0.1,
			engine_number       = 2,
		}, -- end of [1]
	}, -- end of engines_nozzles

    -- Tasks
	Tasks = {
		aircraft_task(Transport),
		aircraft_task(Reconnaissance),
        aircraft_task(AFAC),
    	aircraft_task(AntishipStrike),
    },
	DefaultTask = aircraft_task(AntishipStrike),

-----------------------
-- ANIMATIONS
-----------------------

	AddPropAircraft = { -- Add option to open bomb bay doors at start up
        { id = "Belly Bay Door",  control = 'checkbox', label = _('Start with Open Bay Door'),  defValue = false, weight = 0, arg = 26 },
    },


	    crew_members = {
        [1] = {
--            pilot_name          = "pilot_l39",
			pos					 = {-13.64, 0.435, -2.0},
            ejection_seat_name  = 0,
			drop_canopy_name	=	0,
--            boarding_arg        = 38,
            role                = "pilot",
            role_display_name   = _("Pilot"),
			bailout_arg = -1,
        }, -- end of [1]
        [2] = {
--            pilot_name          = "pilot_l39",
 			pos					 = {12.89, 0.435, 2.0},
            ejection_seat_name  = 0,
			drop_canopy_name	=	0,
--           boarding_arg        = 38,
            pilot_body_arg      = 50, --used for visually removing pilot
            role                = "copilot",
            role_display_name   = _("Navigator"),
			bailout_arg = -1,
        }, -- end of [2]
    }, -- end of crew_members
    crew_stations = "HumanOrchestra",

    mechanimations = {

		BombBay = {
            {Transition = {"Close", "Open"}, Sequence = {
                {C = {{"Arg", 26, "to", 1.0, "in", 12.0, "sign", 1}}},
            }},
            {Transition = {"Open", "Close"}, Sequence = {
                {C = {{"Arg", 26, "to", 0.0, "in", 12.0, "sign", -1}}},
            }},
        },

		FoldableWings = { -- used to close bomb bay door if opened by option
			{Transition = {"Retract", "Extend"}, Sequence = {{C = {{"Arg", 26, "to", 0.0, "in", 6.0}}}}, Flags = {"Reversible"}},
			{Transition = {"Extend", "Retract"}, Sequence = {{C = {{"Arg", 26, "to", 1.0, "in", 30.0}}}}, Flags = {"Reversible", "StepsBackwards"}},
		},

		Door0 = { -- used to open bomb bay door when parked
            {Transition = {"Close", "Open"},  Sequence = {{C = {{"Sleep", "for", 5.0}}}, {C = {{"PosType", 9}, {"Sleep", "for", 10.0}}}, {C = {{"Arg", 26, "to", 1.0, "at", 0.6}}}}},
            {Transition = {"Open", "Close"},  Sequence = {{C = {{"Arg", 26, "to", 0.0, "at", 0.6}}}}},
        },
        Door1 = {DuplicateOf = "Door0"},

        LeftStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 1.0, "in", 9.0}, {"Arg", 116, "to", 1.0, "in", 9.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 5}, {"Arg", 5, "to", 0.0, "in", 12.0}, {"Arg", 116, "to", 0.0, "in", 12.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 5}, {"PosType", 6}, {"Arg", 5, "to", 0.5, "in", 2.0}, {"Arg", 116, "to", 0.5, "in", 2.0}}}}},
        },
        RightStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 1.0, "in", 9.0}, {"Arg", 115, "to", 1.0, "in", 9.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 3}, {"Arg", 3, "to", 0.0, "in", 12.0}, {"Arg", 115, "to", 0.0, "in", 12.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 3}, {"PosType", 7}, {"Arg", 3, "to", 0.5, "in", 2.0}, {"Arg", 115, "to", 0.5, "in", 2.0}}}}},
        },
        CentralStrut = {
            {Transition = {"Retract", "Extend"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 1.0, "in", 7.0}, {"Arg", 117, "to", 1.0, "in", 7.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Extend", "Retract"}, Sequence = {{C = {{"VelType", 4}, {"Arg", 0, "to", 0.0, "in", 8.0}, {"Arg", 117, "to", 0.0, "in", 8.0}}}}, Flags = {"Reversible"}},
            {Transition = {"Any", "Collapse"},   Sequence = {{C = {{"VelType", 4}, {"PosType", 8}, {"Arg", 0, "to", 0.5, "in", 2.0}, {"Arg", 117, "to", 0.5, "in", 2.0}}}}},
        },

    },

    net_animation = { --TODO full list. is this needed for AI?
--        278, 279, 203
    },



-------- FLIGHT MODEL

	SFM_Data = {     --e-3
			aerodynamics =
		{
			Cy0	=	0,
			Mzalfa	=	4.355,
			Mzalfadt	=	0.8,
			kjx	=	2.75,
			kjz	=	0.00125,
			Czbe	=	-0.016,
			cx_gear	=	0.015,
			cx_flap	=	0.05,
			cy_flap	=	1,
			cx_brk	=	0.06,
			table_data =
			{
				[1] = 	{0,	0.023,	0.117,	0.064,	0,	0.5,	20,	1.4},
				[2] = 	{0.2,	0.023,	0.117,	0.064,	0,	1.5,	20,	1.4},
				[3] = 	{0.4,	0.023,	0.117,	0.064,	0,	2.5,	20,	1.4},
				[4] = 	{0.6,	0.025,	0.117,	0.064,	0.022,	3.5,	20,	1.4},
				[5] = 	{0.7,	0.03,	0.117,	0.083,	0.031,	3.5,	20,	1.2},
				[6] = 	{0.8,	0.032,	0.117,	0.107,	0.04,	3.5,	20,	1},
				[7] = 	{0.9,	0.045,	0.117,	0.148,	0.058,	3.5,	20,	0.8},
				[8] = 	{1,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.7},
				[9] = 	{1.5,	0.054,	0.117,	0.199,	0.1,	3.5,	20,	0.2},
			}, -- end of table_data
		}, -- end of aerodynamics
		engine =
		{
			Nmg	=	60.00001,--67.5,
			MinRUD	=	0,
			MaxRUD	=	1,
			MaksRUD	=	1,
			ForsRUD	=	1,
			type	=	"TurboJet",
			hMaxEng	=	19.5,
			dcx_eng	=	0.0085,
			cemax	=	1.24,
			cefor	=	2.56,
			dpdh_m	=	9000,
			dpdh_f	=	9000,
			table_data =
			{
				[1] = 	{0,	373600,	373600},
				[2] = 	{0.2,	312756.6,	312756.6},
				[3] = 	{0.4,	279000,	279000},
				[4] = 	{0.6,	251000,	251000},
				[5] = 	{0.7,	253000,	253000},
				[6] = 	{0.8,	262000,	262000},
				[7] = 	{0.9,	274000,	274000},
				[8] = 	{1,	279000,	279000},
				[9] = 	{1.1,	280000,	280000},
				[10] = 	{1.2,	266000,	266000},
				[11] = 	{1.3,	95001.1,	95001.1},
			}, -- end of table_data
		}, -- end of engine
	},

-----------------------
-- WEAPONS
-----------------------

-- Guns
	Guns 	= {
	},--TODO


--   ammo_type = {}, --TODO

    Pylons =
	{
-- (Pylon #, ext wing=0(no ejection)/ext fuselage=1/internal bay=2, forward/back, up/down, left/right)

		pylon(1, 1, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_01',
			use_full_connector_position = false,
			arg = 308 ,arg_value = 0,
		},
		{
			{ CLSID = "{AGM_84D}", arg_value = 0.1 }, -- AGM-84D Harpoon
			{ CLSID = "{AGM_84H}", arg_value = 0.1 }, --AGM-84H SLAM-ER
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(2, 1, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_02',
			use_full_connector_position = false,
			arg = 309 ,arg_value = 0,
		},
		{
			{ CLSID = "{AGM_84D}", arg_value = 0.1 }, -- AGM-84D Harpoon
			{ CLSID = "{AGM_84H}", arg_value = 0.1 }, --AGM-84H SLAM-ER
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(3, 1, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_03',
			use_full_connector_position = false,
			arg = 311 ,arg_value = 0,
		},
		{
			{ CLSID = "{AGM_84D}", arg_value = 0.1 }, -- AGM-84D Harpoon
			{ CLSID = "{AGM_84H}", arg_value = 0.1 }, --AGM-84H SLAM-ER
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(4, 1, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_04',
			use_full_connector_position = false,
			arg = 312 ,arg_value = 0,
		},
		{
			{ CLSID = "{AGM_84D}", arg_value = 0.1 }, -- AGM-84D Harpoon
			{ CLSID = "{AGM_84H}", arg_value = 0.1 }, --AGM-84H SLAM-ER
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(5, 2, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_05sm', --TEST connectors with sm name are 0.5 scaled connector to reduce LTF5B torpedo to mk54 size
			use_full_connector_position = true,

		},
		{
			{ CLSID = "{LTF_5B}", arg_value = 0.1 },
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),
		pylon(6, 2, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_06sm',
			use_full_connector_position = true,

		},
		{
			{ CLSID = "{LTF_5B}", arg_value = 0.1 },
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(7, 2, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_07sm',
			use_full_connector_position = true,

		},
		{
			{ CLSID = "{LTF_5B}", arg_value = 0.1 },
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(8, 2, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_08sm',
			use_full_connector_position = true,

		},
		{
			{ CLSID = "{LTF_5B}", arg_value = 0.1 },
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(9, 2, 0, 0 , 0,
		{
			connector = 'PNT_PYLON_09sm',
			use_full_connector_position = true,

		},
		{
			{ CLSID = "{LTF_5B}", arg_value = 0.1 },
			{ CLSID = "<CLEAN>", arg_value = 1},
		}
		),

		pylon(10, 1, 0, 0 , 0,

		{
			connector = 'PNT_PYLON_13',
			arg = 1001 ,
--			arg_value = 0,
			use_full_connector_position = false,
			DisplayName = "POD"
		},
		{
			{ CLSID = "payloadCLP_P8_154", arg_value = 0.98},
--			{ CLSID = "<CLEAN>", arg_value = 0},
		}
		),
	},

-----------------------
-- DAMAGE MODEL
-----------------------

			fires_pos =
		{
			[1] = 	{-0.138,	-0.79,	0},
			[2] = 	{-0.138,	-0.79,	1.741},
			[3] = 	{-0.138,	-0.79,	-1.741},
			[4] = 	{-0.82,	0.265,	1.774},
			[5] = 	{-0.82,	0.265,	-1.774},
			[6] = 	{-0.82,	0.255,	1.274},
			[7] = 	{-0.82,	0.255,	-1.274},
			[8] = 	{-0.05,	-1.875,	5.8}, --8,9,10,11 appear to be engine exhaust pos
			[9] = 	{-0.05,	-1.875,	-5.8},
			[10] = 	{-5.024,	-1.353,	1.986},
			[11] = 	{-5.024,	-1.353,	-1.986},
		}, -- end of fires_pos



	Failures = {
	},



	--damage , index meaning see in  Scripts\Aircrafts\_Common\Damage.lua
	Damage = {

	[0] = {critical_damage = 5, args = {146}}, --NOSE_CENTER
	[3] = {critical_damage = 10, args = {65}}, --CABINA / COCKPIT
	[8] = {critical_damage = 10}, --FRONT_GEAR_BOX

	[9]  = {critical_damage = 3,  args = {154}},--FUSELAGE_LEFT_SIDE OK

	[11] = {critical_damage = 1,  args = {168}},--ENGINE_L
	[12] = {critical_damage = 1,  args = {162}},--ENGINE_R

	[15] = {critical_damage = 2,  args = {267}},--LEFT_GEAR_BOX
	[16] = {critical_damage = 2,  args = {266}},--RIGHT_GEAR_BOX
	[17] = {critical_damage = 2,  args = {168}},--ENGINE_L_OUT
	[18] = {critical_damage = 2,  args = {162}},--ENGINE_R_OUT

	[25] = {critical_damage = 2,  args = {226}},--ELERON_L
	[26] = {critical_damage = 2,  args = {216}},--ELERON_R
	[35] = {critical_damage = 6, args = {225, 308, 309}, deps_cells = {25, 37, 17}},--WING_L_IN
	[36] = {critical_damage = 6, args = {215, 311, 312}, deps_cells = {26, 38, 18}},--WING_R_IN
	[37] = {critical_damage = 2,  args = {227, 228}},--FLAP_L_IN
	[38] = {critical_damage = 2,  args = {217, 218}},--FLAP_R_IN

	[43] = {critical_damage = 2,  args = {243}},--FIN_L_BOTTOM radome
	[44] = {critical_damage = 2,  args = {242}, deps_cells = {53}},--FIN_R_BOTTOM

	[51] = {critical_damage = 2,  args = {240}},--ELEVATOR_L_IN
	[52] = {critical_damage = 2,  args = {238}},--ELEVATOR_R_IN
	[53] = {critical_damage = 2, args = {247}},  -- rudder

	[55] = {critical_damage = 15, args = {81}, deps_cells = {51, 52}},  --tail

	},



	DamageParts =
	{
		[1] = "CLP_P8_WING_R", -- wing R
		[2] = "CLP_P8_WING_L", -- wing L
--		[3] = "kc-135-oblomok-noise", -- nose
--		[4] = "kc-135-oblomok-tail-r", -- tail
--		[5] = "kc-135-oblomok-tail-l", -- tail
	},

-----------------------
-- LIGHTING
-----------------------

    lights_data = {
        typename = "collection",
        lights = {
            [WOLALIGHT_LANDING_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- Landing Light
                        typename = "collection",
                        lights = {
							{
                                typename = "spotlight", connector = "LDG1_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG1_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG1_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR", argument = 208,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "LDG2_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "LDG2_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
                    { -- 1 -- Landing / Taxi Light
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "RESERV_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							 {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_TAXI_LIGHTS] = {
                typename = "collection",
                lights = {
                    { -- 0 -- NW Light
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "TAXI_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "TAXI_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "TAXI_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
					{ -- 1 -- Landing / Taxi Light
                        typename = "collection",
                        lights = {
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "RESERV_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "RESERV_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
							 {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR", argument = 209,
                                proto = lamp_prototypes.LFS_P_27_600, angle_max = math.rad(18.0), angle_min = math.rad(11.0), angle_change_rate = math.rad(32.0 * 0.25),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "spotlight", connector = "MAIN_SPOT_PTR",
                                proto = lamp_prototypes.LFS_P_27_600, range = 24.0, angle_max = math.rad(136.0), angle_min = math.rad(116.0), angle_change_rate = math.rad(-52.0),
                                power_up_t = 2.8, movable = true,
                            },
                            {
                                typename = "Omni", connector = "MAIN_SPOT_PTR", pos_correction = {0.2, 0.0, 0.0},
                                proto = lamp_prototypes.LFS_P_27_600, range = 6.0,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_NAVLIGHTS] = {
                typename = "Collection",
                lights = {
                    { -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_1", argument = 190,
                        proto = lamp_prototypes.BANO_7M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_1",
                                proto = lamp_prototypes.BANO_7M_red,
								range = 9.0,
                            },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_2", argument = 191,
                        proto = lamp_prototypes.BANO_7M_green, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_2",
                                proto = lamp_prototypes.BANO_7M_green,
--								range = 9.0,
                            },
                    { -- 2 -- Tail Position Light (WHITE)
                        typename = "Collection",
                        lights = {
                            {
                                typename = "Spot", connector = "BANO_0", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
							{
                                typename = "Spot", connector = "FLOW_001", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_001",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
														                            {
                                typename = "Spot", connector = "FLOW_002", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_002",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
                        },
                    },
                },
            },
            [WOLALIGHT_AUX_LIGHTS] = {
                typename = "collection",
                lights = {

                },
            },
            [WOLALIGHT_CABIN_BOARDING] = {
                typename = "collection",
                lights = {
 --                   { -- 0 -- Dome Light -- TODO THIS ANIMATES A VISIBLE LIGHT IN MODEL
 --                       typename = "Argument", argument = 296,
 --                   },
 --                   { -- 1 -- LH Panel Floodlight -- TODO THIS ANIMATES A VISIBLE LIGHT IN MODEL
 --                      typename = "Argument", argument = 302,
 --                   },
                },
            },
			[WOLALIGHT_STROBES] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
						lights = {

							{
								typename = "natostrobelight", connector = "RED_BEACON", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
														{
								typename = "natostrobelight", connector = "RED_BEACON2", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
														{
								typename = "natostrobelight", connector = "RED_BEACON3", argument = 193,
								proto = lamp_prototypes.SMI_2KM,
							},
						},
					},
				},
			},
			[WOLALIGHT_CABIN_NIGHT] = {
				typename = "collection",
				lights = {
					{
						typename = "collection",
						lights = {
							{
								typename = "argumentlight", argument = 69,
							},
--							{
--								typename = "omnilight", connector = "PNT_CABIN",
--								color = {0.0, 1.0, 0.3, 0.5}, range = 3.0,
--							},
--							{
--                                typename = "Omni", connector = "NT_CABIN",
--                                proto = lamp_prototypes.BANO_7M_green,
--								range = 3.0,
--                            },
						},
					},
				},
			},
			[WOLALIGHT_REFUEL_LIGHTS] = {
            typename = "collection",
            lights = {


				--NAV LIGHTING

				{ -- 0 -- Left Position Light (RED)
                        typename = "Spot", connector = "BANO_1", argument = 190,
                        proto = lamp_prototypes.BANO_7M_red, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_1",
                                proto = lamp_prototypes.BANO_7M_red,
								range = 9.0,
                            },
                    { -- 1 -- Right Position Light (GREEN)
                        typename = "Spot", connector = "BANO_2", argument = 191,
                        proto = lamp_prototypes.BANO_7M_green, angle_max = math.rad(160.0), angle_min = math.rad(90.0),
                    },
							{
                                typename = "Omni", connector = "BANO_2",
                                proto = lamp_prototypes.BANO_7M_green,
--								range = 9.0,
                            },
                    { -- 2 -- Tail Position Light (WHITE)
                        typename = "Collection",
                        lights = {
                            {
                                typename = "Spot", connector = "BANO_0", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "BANO_0",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
							{
                                typename = "Spot", connector = "FLOW_001", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_001",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
														                            {
                                typename = "Spot", connector = "FLOW_002", argument = 192,
                                proto = lamp_prototypes.ANO_3_Bl,
                            },
                            {
                                typename = "Omni", connector = "FLOW_002",
                                proto = lamp_prototypes.ANO_3_Bl, range = 9.0,
                            },
                        },
                    },


            },
        },

        },
    },


}


add_aircraft(CLP_P8)
